﻿// FirstParagraphView.jsx

// Вся информация на кнопке [?]
// 29.10.2025

#targetengine "FirstParagraphView"

var ms_001 = "Нулевой абзацный отступ первого абзаца текста";
var ms_002 = "Скрипт должен быть размещён в пользовательской папке скриптов, она называется 'Пользователь'. В английской версии индизайна эта папка именуется 'User'.\r\rСейчас он или в папке демонстрационных скриптов 'Программа' ('Application'), или в папке 'Сообщество' (Community). Но в этих папках запрещено сохранять установки скрипта, чтобы восстановить их при следующем запуске.";
var ms_003 = "Эта программа для индизайна CS6+.";
var ms_004 = "Перед запуском скрипта откройте документ.";
var ms_005 = "Это только что созданный и ещё ни разу не сохранённый файл.\nДайте ему имя.";
var ms_006 = "Файл не был сохранён с новым именем.";
var ms_007 = "Абзацный стиль заголовка";
var ms_008 = "Число абзацев между заголовком и текстом";
var ms_009 = "Абзацный стиль текста";
var ms_010 = "Сделать нулевой отступ в установках абзаца";
var ms_011 = "Сделать абзацный стиль с нулевым отступом";
var ms_012 = "Сделать абзацный отступ нулевым";
var ms_013 = "Выбраны одинаковые стили.";
var ms_014 = "Должна быть выделена область текста.";
var ms_015 = "Заголовки не найдены.";
var ms_016 = "Текст обработан.";
var ms_017 = "= Причина появления этой программы =\nЯн Чихольд (Jan Tschichold) когда-то высказал такую интересную мысль: «Ненулевой абзацный отступ важен только для абзацев внутри текста, чтобы визуально отделять один абзац от другого. Но когда это первый абзац после заголовка, то абзацный отступ не нужен».\nЭто очень здравая мысль, но она легко реализуется только в ручном наборе. В InDesign надо позаботиться об отдельном абзацном стиле для этого первого абзаца. Идея просто автоматически в первом абзаце после заголовка делать абзацный отступ нулевым может создать дополнительные проблемы: если после заголовка идёт подзаголовок или эпиграф, это потребует отдельных действий.\nВ итоге яркая идея увязла в сложностях учёта всех случаев. Но она от этого хуже не стала. Надо  просто попробовать учесть эти частные случаи, и результат должен быть прекрасным. Вот программа, которая знает о разных вариантах соотношения заголовка и текста, и в результате идея Чихольда легко реализуется.\n\n= Описание программы =\nОпределяются абзацный стиль заголовка и абзацный стиль текста. Эти стили могут быть как автономными, так и в составе группы.\n\nВозможное число дополнительных абзацев между заголовком и текстом указывается радиокнопками.\n\"0\" — программа ищет текст, оформленный указанным абзацным стилем, в абзаце, идущем сразу после заголовка.\n\"1\" — между заголовком и текстом может быть один абзац, например, подзаголовок или эпиграф. (А может и не быть.) Поэтому текст ищется в двух абзацах, идущих после заголовка.\n\"2\" — между заголовком и текстом могут быть два дополнительных абзаца. Текст ищется в трёх абзацах, идущих после заголовка.\nЕсли текст не найден, программа переходит к обработке следующего заголовка в выделенном тексте.\n\nЕсли текст указанного абзацного стиля найден, в нём абзацный отступ делается нулевым.\n\nЕсть два варианта оформления этого первого абзаца, они определяются радиокнопками.\n\n> Радиокнопка \"Сделать нулевой отступ в установках абзаца\"\nВ установках абзаца отступ делается нулевым. В панели абзацных стилей рядом с именем стиля будет знак плюс, указывающий на локальное изменение приложенного стиля.\n\n> Радиокнопка \"Сделать абзацный стиль с нулевым отступом\"\nНа базе абзацного стиля этого абзаца создаётся новый стиль. В его установках будет изменён только абзацный отступ. Имя этого стиля совпадает с именем базового абзацного стиля, но в конце есть суффикс '_zi' (zi = zero indent).\nНапример, базовый стиль 'text', а новый стиль 'text_zi'.\nЕсли базовый стиль входит в группу, то новый стиль будет в составе этой группы.\n\nПервые строки абзацев с обнулённым абзацным отступом отмечаются условным цветом. При изменении абзацного отступа первого абзаца без создания нового стиля это желтый цвет. Если создаётся новый абзацный стиль, то цвет будет зелёным.\nЦвет исчезнет при закрытии программы.\n\nЕсли результат работы программы не совпал с ожиданиями, клавишами Ctrl+Z можно вернуть прежнее состояние вёрстки.\n\nЭтот текст можно выделить и взять в буфер.\n\nЕсли у вас есть мысли и идеи о развитии этого решения, пишите: dotextok@gmail.com\nМихаил Иванюшин\n\nhttps://dotextok.ru • 2025\n"

//////////////////////
var programTitul = ms_001; // "Нулевой абзацный отступ первого абзаца текста"
var scriptFile = myGetScriptPath();
var scriptFolder = decodeURI(scriptFile.path);
if (scriptFolder.match ('Version') == null) {
    alert (ms_002, programTitul);  // "Скрипт должен быть размещён в пользовательской папке скриптов, она называется 'Пользователь'. В английской версии индизайна эта папка именуется 'User'.\r\rСейчас он или в папке демонстрационных скриптов 'Программа' ('Application'), или в папке 'Сообщество' (Community). Но в этих папках запрещено сохранять установки скрипта, чтобы восстановить их при следующем запуске."
    exit(); 
    }
if (parseInt (app.version) < 8) {
    alert(ms_003,programTitul); // "Эта программа для индизайна CS6+."
    exit();    
    }
if (app.documents.length == 0) {
    alert(ms_004,programTitul); // "Перед запуском скрипта откройте документ."
    exit();
    }
var doc = app.activeDocument;
var docName = decodeURI(doc.name).split(".indd")[0];
var noName = false;
try { var fullName = decodeURI(doc.fullName); } // если документ не сохранён, маршрут не сообщается
catch(e) {
   alert(ms_005,programTitul); // "Это только что созданный и ещё ни разу не сохранённый файл.\nДайте ему имя."
   noName = true;
    }
if (noName) { // noName
    try { doc.save(); }
    catch (e) {
         alert(ms_006,programTitul);  // "Файл не был сохранён с новым именем."
         exit();
        }
    } // noName

var theConditionP = [];
var zeroIndentColor_line = [243, 228, 72];
var zeroIndentColor_style = [0, 228, 0];
var zeroIndentCondition_line = "#zeroIndent_line";
var zeroIndentCondition_style = "#zeroIndent_style";

var sel, story;
var paraStyleList = [];    
var paraStyleID = [];  
var count = 1;

while (paraStyleList.length > 0) paraStyleList.shift();
while (paraStyleID.length > 0) paraStyleID.shift();
var myParagraphStyles = app.activeDocument.allParagraphStyles;
var myParagraphStyleName, obj;
for (i = 0; i < myParagraphStyles.length ; i++) { // for
    myParagraphStyleName = myParagraphStyles[i].name;
    obj = myParagraphStyles[i];
    while(obj.parent instanceof ParagraphStyleGroup) {
        myParagraphStyleName = myParagraphStyleName + " (" + obj.parent.name + ")";        
        obj = obj.parent;  
        }
    paraStyleList.push(myParagraphStyleName);
    paraStyleID.push(myParagraphStyles[i].id);    
    } // for
paraStyleList.shift(); // удаление стиля No Paragraph Style
paraStyleID.shift();

var headerStyleName = "";
var theHeaderStyleValue = 0;
var theTextStyleName = "";
var theTextStyleValue = 0;

var myDefSetName  = docName + ".ini"; // это файл установок программы
var myScriptFile = myGetScriptPath();
var myScriptFolder = decodeURI(myScriptFile.path);
var setFolderPath = new Folder (myScriptFolder + "/" + "sets"); 
if (setFolderPath.exists == false) {   
    setFolderPath.create();
    }
var myFilePath = decodeURI(myScriptFolder + "/sets/" + myDefSetName); 
var myDataFile = new File (myFilePath);
if (myDataFile.open("r")) { // такой файл есть 
    headerStyleName = myDataFile.readln();
    theHeaderStyleValue = testParaStyleName(headerStyleName);    
    theTextStyleName = myDataFile.readln();
    theTextStyleValue = testParaStyleName(theTextStyleName);     
    myDataFile.close();
    } // "r"    

colorClear();
doc.conditions.add ({name:zeroIndentCondition_line, indicatorColor:zeroIndentColor_line, indicatorMethod:ConditionIndicatorMethod.USE_HIGHLIGHT, visible:true});
theConditionP[0] = doc.conditions.item(zeroIndentCondition_line);
doc.conditions.add ({name:zeroIndentCondition_style, indicatorColor:zeroIndentColor_style, indicatorMethod:ConditionIndicatorMethod.USE_HIGHLIGHT, visible:true});
theConditionP[1] = doc.conditions.item(zeroIndentCondition_style);
    
///////////////////////////////////
var w = new Window("palette", programTitul);
w.alignChildren = ["fill", "fill"];
var listWidth = 140;
var theHeaderStyleGroup = w.add("group");
theHeaderStyleGroup.orientation = "row";
var theHeaderStyle = theHeaderStyleGroup.add ("dropdownlist", undefined, paraStyleList); 
theHeaderStyle.minimumSize.width = theHeaderStyle.maximumSize.width = listWidth;
theHeaderStyle.selection = theHeaderStyleValue;
theHeaderStyleGroup.add("statictext", undefined, ms_007); // "Абзацный стиль заголовка"
////
w.add("statictext", undefined, ms_008); // "Число абзацев между заголовком и текстом"
var rbGroup = w.add("group");
rbGroup.orientation = "row";
var para0 = rbGroup.add("radiobutton", undefined, "0");
var para1 = rbGroup.add("radiobutton", undefined, "1");
var para2 = rbGroup.add("radiobutton", undefined, "2");
para0.value = true;
///
var theTextStyleGroup = w.add("group");
theTextStyleGroup.orientation = "row";
var theTextStyle = theTextStyleGroup.add ("dropdownlist", undefined, paraStyleList); 
theTextStyle.minimumSize.width = theTextStyle.maximumSize.width = listWidth;
theTextStyle.selection = theTextStyleValue;
theTextStyleGroup.add("statictext", undefined, ms_009); // "Абзацный стиль текста"
var simpleZeroIndent = w.add("radiobutton", undefined, ms_010); // "Сделать нулевой отступ в установках абзаца"
var paraZeroIndent = w.add("radiobutton", undefined, ms_011); // "Сделать абзацный стиль с нулевым отступом"
simpleZeroIndent.value = true;
separator1 = w.add ("panel"); 
separator1.minimumSize.height = separator1.maximumSize.height = 1;
separator1.alignment = ["fill", "fill"];
var buttonsGroup = w.add("group");
buttonsGroup.orientation = "row";
buttonsGroup.alignChildren = ["center", "center"];
var info = buttonsGroup.add("button", [0,0,28,28] , "?");
var action = buttonsGroup.add("button", [0,0,280,28] , ms_012); // "Сделать абзацный отступ нулевым"
///
para0.onClick = function () { count = 1; }
para1.onClick = function () { count = 2; }
para2.onClick = function () { count = 3; }
///
action.onClick = function () { // action
if (String(theHeaderStyle.selection) == String(theTextStyle.selection)) {
    alert(ms_013,programTitul); // "Выбраны одинаковые стили."
    return;        
    }
sel = app.selection[0];
if (sel == null || sel.constructor.name == "TextFrame" || sel.hasOwnProperty("pointSize") != true || sel.constructor.name == "InsertionPoint") {
    alert(ms_014,programTitul); // "Должна быть выделена область текста."
    return;    
    }
story = sel.parentStory;
app.doScript(actionSteps, ScriptLanguage.JAVASCRIPT , [], UndoModes.ENTIRE_SCRIPT, programTitul); 
doc.select(NothingEnum.nothing);
app.activate();
return;
///
function actionSteps() { // actionSteps  
app.findGrepPreferences = app.changeGrepPreferences = null; 
app.findGrepPreferences.findWhat = ".+";
app.findGrepPreferences.appliedParagraphStyle = app.activeDocument.paragraphStyles.itemByID(paraStyleID[Number(theHeaderStyle.selection)]);            
var rez = sel.findGrep();
if (rez.length == 0) {
    alert(ms_015, programTitul); // "Заголовки не найдены."
    return;
    }
var headerPara, nextPara, paraName, groupName, name_zi, notFound;
var theName;
for (var i = 0; i < rez.length; i++) { // i++
    headerPara = rez[i].paragraphs[0];
    nextPara = story.paragraphs.nextItem(headerPara);
    // в нескольких абзацах после найденного заголовка ищем текст, оформленный текстовым стилем 
    // (необязательно текст идёт сразу после заголовка. Может быть и подзаголовок, и эпиграф)
    for (var c = 0; c < count; c++) { // c++
        if (nextPara.appliedParagraphStyle == app.activeDocument.paragraphStyles.itemByID(paraStyleID[Number(theTextStyle.selection)])) { // nextPara
            if (simpleZeroIndent.value == true) { // simpleZeroIndent
                nextPara.firstLineIndent = 0;
                nextPara.lines[0].applyConditions (theConditionP[0], true); 
                } // simpleZeroIndent
            else { // paraZeroIndent
                theName = nextPara.appliedParagraphStyle.name;
                if (nextPara.appliedParagraphStyle.parent.constructor.name != "ParagraphStyleGroup") { // != PSG
                // абзацный стиль не находится в группе
                    name_zi = theName + "_zi";
                // поиск абзацного стиля с именем name_zi
                    notFound = true;
                    myParagraphStyles = app.activeDocument.allParagraphStyles;
                    myParagraphStyleName;
                    for (var ii = 0; ii < myParagraphStyles.length ; ii++) { // ii++
                        myParagraphStyleName = myParagraphStyles[ii].name;
                        if (myParagraphStyleName != name_zi) continue;
                        notFound = false;
                        break;
                        } // ii++
                    if (notFound == false) {
                        nextPara.appliedParagraphStyle = app.activeDocument.paragraphStyles.item(name_zi);
                        nextPara.lines[0].applyConditions (theConditionP[1], true);
                        }
                    else {
                        var nS = app.activeDocument.paragraphStyles.item(theName).duplicate();
                        nS.name = name_zi;
                        nS.firstLineIndent = 0;
                        nextPara.appliedParagraphStyle = nS;
                        nextPara.lines[0].applyConditions (theConditionP[1], true);                        
                        }
                    }  // != PSG       
                else { // ParagraphStyleGroup
                // абзацный стиль находится в группе. Ищем в этой группе стиль с именем name_zi
                    name_zi = theName + "_zi";
                    groupName = nextPara.appliedParagraphStyle.parent.name;
                // поиск абзацного стиля с именем name_zi в группе с именем groupName
                    notFound = true;
                    myParagraphStyles = app.activeDocument.allParagraphStyles;
                    myParagraphStyleName;
                    for (var ii = 0; ii < myParagraphStyles.length ; ii++) { // ii++
                        myParagraphStyleName = myParagraphStyles[ii].name;                
                        obj = myParagraphStyles[ii];
                        if (obj.parent.constructor.name != "ParagraphStyleGroup" || obj.parent.name != groupName) continue;                      
                        if (myParagraphStyleName != name_zi) continue;
                        notFound = false;
                        break;
                        } // ii++
                    if (notFound == false) {
                        nextPara.appliedParagraphStyle = app.activeDocument.paragraphStyleGroups.item(groupName).paragraphStyles.item(name_zi);
                        nextPara.lines[0].applyConditions (theConditionP[1], true);
                        }
                    else {
                        var nS = app.activeDocument.paragraphStyleGroups.item(groupName).paragraphStyles.item(theName).duplicate();
                        nS.name = name_zi;
                        nS.firstLineIndent = 0;
                        nextPara.appliedParagraphStyle = nS;
                        nextPara.lines[0].applyConditions (theConditionP[1], true);                        
                        }
                    }  // ParagraphStyleGroup               
                } // paraZeroIndent
            break;
            } // nextPara
        else {
            headerPara = nextPara;
            nextPara = story.paragraphs.nextItem(headerPara);
            continue;
            }
        } // c++
    } // i++
///
showMes(ms_016); // "Текст обработан."
return;
} // actionSteps
////
} // action
///
theHeaderStyle.onActivate = function () { theHeaderStyle.helpTip = theHeaderStyle.selection; }
theTextStyle.onActivate = function () { theTextStyle.helpTip = theTextStyle.selection; }
///
w.onClose = function () { // onClose
myDataFile.open("w");
myDataFile.writeln(theHeaderStyle.selection);
myDataFile.writeln(theTextStyle.selection);
myDataFile.close(); 
colorClear();
app.activate(); 
} // onClose
///
info.onClick = function () { // info.onClick
var textInfo = ms_017; // 
var wn = new Window ("dialog", programTitul);
var data = wn.add("edittext", [0, 0, 850, 690], textInfo, {multiline: true});
wn.layout.layout();
wn.show();
return;
} // info.onClick
////
// выбраный стиль всегда во всплывающей подсказке выпадающего списка
theHeaderStyle.helpTip = theHeaderStyle.selection;
theTextStyle.helpTip = theTextStyle.selection;
///
w.show();
/////
function testParaStyleName(theStyleName) { // testParaStyleName   
var theStyleSelection = 0;
var nameNotFound = true;
for (var i = 0; i < paraStyleList.length; i++) {
    if (paraStyleList[i] != theStyleName) continue;
    nameNotFound = false;
    break;
    }
if (nameNotFound == false) theStyleSelection = i;
return theStyleSelection;
} // testParaStyleName
///
function myGetScriptPath() { // myGetScriptPath
try{
return app.activeScript;
}
catch(myError) {
return File (myError.fileName);
}
} // myGetScriptPath
////
function showMes(mes) { // showMes
var ewin = new Window ("palette", mes, {x:0, y:0, width:600, height:12}); 
ewin.center();
ewin.show();
ewin.update();   
$.sleep(1000);
ewin.close();
app.activate();
return;
} // showMes
////
function colorClear () { // colorClear
while (theConditionP.length > 0) theConditionP.pop();    
try { doc.conditions.item(zeroIndentCondition_line).remove(); } catch (e) { }
try { doc.conditions.item(zeroIndentCondition_style).remove(); } catch (e) { }
} // colorClear
////


